<?php

namespace App\Models\Calculator;

use Illuminate\Database\Eloquent\Model;

class CalculatorQuestion extends Model 
{

    protected $table = 'calculator_questions';
    public $timestamps = true;
    protected $fillable = array('type', 'show_selected');

    public function calculator()
    {
        return $this->belongsTo('Calculator');
    }

    public function items()
    {
        return $this->hasMany('CalculatorQuestionItem');
    }

    public function category()
    {
        return $this->belongsTo('CalculatorCategory');
    }

    public function invoiceCategory()
    {
        return $this->belongsTo('CalculatorInvoiceCategory');
    }

}